/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.internal.commands;

import com.aptana.core.logging.IdeLog;
import com.aptana.ui.UIPlugin;
import java.io.File;
import java.net.URI;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class ViewLogCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String logFile = System.getProperty("osgi.logfile");
        try {
            this.openEditorForFile(logFile);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    private void openEditorForFile(String filePath) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            Path path = new Path(filePath);
            IFile fileForLocation = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor editorDescriptor = null;
            if (fileForLocation == null) {
                IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(filePath);
                editorDescriptor = editorRegistry.getDefaultEditor(filePath, contentType);
            } else {
                editorDescriptor = editorRegistry.getDefaultEditor(filePath);
            }
            String editorId = editorDescriptor == null ? "com.aptana.editor.text" : editorDescriptor.getId();
            try {
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (URI)file.toURI(), (String)editorId, (boolean)true);
            }
            catch (PartInitException e) {
                IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
            }
        }
    }
}

